import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors for statuses
colors = {
    'clear': 'green',
    'not clear': 'red',
    'hand empty': 'blue',
    'hand holding': 'orange'
}

# Add table
table = patches.Rectangle((0, 0), 8, 1, linewidth=1, edgecolor='black', facecolor='lightgrey')
ax.add_patch(table)
ax.text(4, 0.5, 'Table', ha='center', va='center', fontsize=10, color='black')

# Add blocks
blocks = {
    'a': {'pos': (1, 1), 'status': 'not clear'},
    'b': {'pos': (3, 1), 'status': 'not clear'},
    'c': {'pos': (3, 2), 'status': 'clear'},
    'd': {'pos': (1, 2), 'status': 'clear'},
    'e': {'pos': (5, 1), 'status': 'clear'}
}

for block, info in blocks.items():
    rect = patches.Rectangle(info['pos'], 1, 1, linewidth=1, edgecolor='black', facecolor=colors[info['status']])
    ax.add_patch(rect)
    ax.text(info['pos'][0] + 0.5, info['pos'][1] + 0.5, f'Block {block}\n{info["status"]}', ha='center', va='center', fontsize=8, color='white')

# Add hand
hand = patches.Ellipse((7, 3), 1, 0.5, linewidth=1, edgecolor='black', facecolor=colors['hand empty'])
ax.add_patch(hand)
ax.text(7, 3, 'Hand\nempty', ha='center', va='center', fontsize=8, color='white')

# Add legend
legend_elements = [
    patches.Patch(facecolor='green', edgecolor='black', label='Clear'),
    patches.Patch(facecolor='red', edgecolor='black', label='Not Clear'),
    patches.Patch(facecolor='blue', edgecolor='black', label='Hand Empty'),
    patches.Patch(facecolor='orange', edgecolor='black', label='Hand Holding')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 8)
ax.set_ylim(0, 4)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_6.png')
plt.close()